package joyfill

import koncurrent.Later

interface UsersApi {

    /**
     * Get users
     *
     * @param limit A limit on the number of objects to be returned. Limit can range between 1 and 100
     * @param page For use with pagination. For instance, if limit is set to 25 and you set page to 2 then results 26-50 will be returned.
     * @param type The type of users you want to return. See the users Overview page for more information about user types.
     * @param group Filter users by a specific group identifier. Only users that belong to the specified group will be returned.
     *
     * @return a [Later] of a [List] of [User]s
     */
    fun list(limit: Int = DEFAULT_LIMIT, page: Int = 1, type: UserType = UserType.all, group: String? = null): Later<List<User>>
}