package joyfill

import koncurrent.Later

interface TemplatesApi {

    /**
     * Get documents
     *
     * @param limit A limit on the number of objects to be returned. Limit can range between 1 and 100
     * @param page For use with pagination. For instance, if limit is set to 25 and you set page to 2 then results 26-50 will be returned.
     * @param group Filter templates by a specific group identifier. Only templates that belong to the specified group will be returned
     *
     * @return a [Later] of a [List] of [User]s
     */
    fun list(
        limit: Int = DEFAULT_LIMIT,
        page: Int = 1,
        group: String? = null,
        stage: JoyStage = JoyStage.published
    ): Later<List<Document>>
}