package joyfill

import koncurrent.Later

interface GroupsApi {

    /**
     * Create a group
     * @param [identifier] Specifies a group's unique ID.
     * Maximum length is 80 characters.
     * * Don't use personally identifiable information (PII)
     * such as the user's email address, legal name, or phone number.
     * Identifier cannot be changed after creation.
     * Leave the identifier param empty to have Joyfill auto generate an identifier.
     * @param [title] the title of the group
     * @return a [Later] of a the created [Group]
     */
    fun create(identifier: String, title: String): Later<Group>

    /**
     * Create a group
     * @param [title] the title of the group
     * @return a [Later] of a the created [Group]
     */
    fun create(title: String): Later<Group>

    /**
     * List all groups
     *
     * @param limit A limit on the number of objects to be returned. Limit can range between 1 and 100
     * @param page For use with pagination. For instance, if limit is set to 25 and you set page to 2 then results 26-50 will be return
     *
     * @return a [Later] of a [List] of [Group]
     */
    fun list(limit: Int = DEFAULT_LIMIT, page: Int = 1): Later<List<Group>>
}