package joyfill

import koncurrent.Later

interface DocumentsApi {

    /**
     * Create a raw document
     *
     * @param document The raw document to be created
     */
    fun create(document: Document): Later<Document>

    /**
     * Update a document with new information
     *
     * @param document The document that needs updating
     */
    fun update(document: Document): Later<Document>

    /**
     * Get documents
     *
     * @param limit A limit on the number of objects to be returned. Limit can range between 1 and 100
     * @param page For use with pagination. For instance, if limit is set to 25 and you set page to 2 then results 26-50 will be returned.
     * @param template Specifies an original source template identifier to filter documents
     * @param group Filter documents by a specific group identifier. Only documents that belong to the specified group will be returned
     *
     * @return a [Later] of a [List] of [User]s
     */
    fun list(
        limit: Int = DEFAULT_LIMIT,
        page: Int = 1,
        template: String? = null,
        group: String? = null,
        stage: JoyStage = JoyStage.published
    ): Later<List<Document>>

    /**
     * Delete a document
     * @param identifier The document's identifier
     */
    fun delete(identifier: String): Later<String>
}