package joyfill

import io.ktor.client.HttpClient
import joyfill.internal.ApiImpl
import joyfill.internal.config.AccessTokenConfig
import joyfill.internal.config.ApiKeyConfig
import koncurrent.Executor
import kotlinx.serialization.StringFormat

fun JoyfillApi(
    publicKey: String,
    secretKey: String,
    url: String = DEFAULT_URL,
    version: String = DEFAULT_VERSION,
    executor: Executor = DEFAULT_EXECUTOR,
    http: HttpClient = DEFAULT_HTTP_CLIENT,
    codec: StringFormat = DEFAULT_CODEC,
): Api = ApiImpl(ApiKeyConfig(url, version, executor, http, codec, publicKey, secretKey))

fun JoyfillApi(
    accessToken: String,
    url: String = DEFAULT_URL,
    version: String = DEFAULT_VERSION,
    executor: Executor = DEFAULT_EXECUTOR,
    http: HttpClient = DEFAULT_HTTP_CLIENT,
    codec: StringFormat = DEFAULT_CODEC
): Api = ApiImpl(AccessTokenConfig(url, version, executor, http, codec, accessToken))