package joyfill.internal

import joyfill.Document
import joyfill.JoyStage
import joyfill.TemplatesApi
import joyfill.internal.config.ApiConfig
import joyfill.toDocument
import koncurrent.Later
import koncurrent.coroutines.asCoroutineScope
import koncurrent.later
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.JsonArray
import kotlinx.serialization.json.JsonObject

internal class TemplatesApiImpl(config: ApiConfig) : AbstractJoyfillApi(config), TemplatesApi {

    private val scope by lazy { config.executor.asCoroutineScope() }
    override fun list(
        limit: Int,
        page: Int,
        group: String?,
        stage: JoyStage,
    ): Later<List<Document>> = scope.later {
        if (limit !in 1..100) throw IllegalArgumentException("limit must be between 1 and 100")
        val json = mapOf(
            "limit" to limit,
            "page" to page,
            "stage" to stage,
            "group" to group
        ).joyGet("templates")
        (config.codec.decodeFromString<JsonObject>(json)["data"] as JsonArray).map {
            (it as JsonObject).toDocument()
        }
    }
}