package joyfill.tools.validation

import joyfill.components.Component

sealed interface ComponentValidity : Validity {
    val component: Component
    val messages: List<String>
}

data class ComponentValid(
    override val component: Component,
    override val messages: List<String>
) : ComponentValidity, Valid {
    companion object {
        fun empty(component: Component): ComponentValid {
            return ComponentValid(component, emptyList())
        }
    }
}

data class ComponentInvalid(
    override val component: Component,
    override val messages: List<String>
) : ComponentValidity, Invalid {
    companion object {
        fun empty(component: Component): ComponentInvalid {
            return ComponentInvalid(component, emptyList())
        }
    }
}