@file:Suppress("DELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE")

package joyfill.editors.unknown

import cinematic.mutableLiveOf
import joyfill.Document
import joyfill.collections.PageCollection
import joyfill.components.Component
import joyfill.components.ComponentSchema
import joyfill.editors.components.ComponentEditor
import joyfill.editors.components.internal.AbstractComponentEditor
import joyfill.editors.table.HiddenReason
import joyfill.events.ChangeEvent
import joyfill.events.EventDispatcher
import joyfill.tools.validation.ComponentValid
import joyfill.tools.validation.ComponentValidityState
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class UnknownEditor(
    component: Component,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
    dependents: () -> List<ComponentEditor>,
    resolver: ResolutionResource,
    library: Library?,
) : AbstractComponentEditor(document, pages, component, {}, onChange, identifier, fieldId, dispatcher, dependents, resolver, library),
    ComponentEditor,
    ComponentSchema by component {
    override val state by lazy { mutableLiveOf(State(component)) }

    data class State(private val component: Component) : ComponentValidityState {
        override val validity = ComponentValid.empty(component)
    }

    override fun setHiddenTo(value: Boolean, reason: HiddenReason, liveUpdate: Boolean) {
        hidden = value
    }
}
