package joyfill.editors.table.utils

import joyfill.Type
import joyfill.editors.table.ColumnSorter
import joyfill.editors.table.RowManager
import joyfill.editors.table.SortingOption.Ascending
import joyfill.editors.table.SortingOption.Descending
import joyfill.editors.table.SortingOption.None

internal fun <M : RowManager> List<M>.sort(sorter: ColumnSorter): List<M> {
    val selector = sorter.toFunction()
    return when (sorter.sort) {
        Ascending -> sortedBy(selector)
        Descending -> sortedByDescending(selector)
        None -> this
    }
}

internal fun ColumnSorter.toFunction(): (RowManager) -> Comparable<Any>? = when (this.type) {
    is Type.text -> { manager ->
        manager.text(column?.id)?.state?.value?.data as? Comparable<Any>
    }

    is Type.number -> { manager ->
        manager.number(column?.id)?.state?.value?.data as? Comparable<Any>
    }

    is Type.barcode -> { manager ->
        manager.barcode(column?.id)?.state?.value?.data as? Comparable<Any>
    }

    is Type.dropdown -> { manager ->
        manager.dropdown(column?.id)?.state?.value?.data?.value as? Comparable<Any>
    }

    is Type.multiSelect -> { manager ->
        null
    }

    else -> { _ -> null }
}