package joyfill.editors.table.utils

import joyfill.barcode.BarcodeColumn
import joyfill.block.BlockColumn
import joyfill.date.DateColumn
import joyfill.dropdown.DropdownColumn
import joyfill.file.FileColumn
import joyfill.image.ImageColumn
import joyfill.multi_select.MultiSelectColumn
import joyfill.number.NumberColumn
import joyfill.signature.SignatureColumn
import joyfill.table.Cells
import joyfill.table.TableSchema
import joyfill.table.toCells
import joyfill.text.TextColumn
import joyfill.text_area.TextAreaColumn
import joyfill.utils.Attachment

fun TableSchema.intiCells(empty: Boolean): Cells = columns.toCells(
    columns.flatMap { column ->
        listOf(
            column.id to when (column) {
                is TextColumn -> if (empty) null else column.value
                is TextAreaColumn -> if (empty) null else column.value
                is BarcodeColumn -> if (empty) null else column.value
                is NumberColumn -> if (empty) null else column.value
                is DateColumn -> if (empty) null else column.value
                is DropdownColumn -> if (empty) null else column.value
                is SignatureColumn -> if (empty) null else column.value
                is BlockColumn -> if (empty) null else column.value
                is ImageColumn -> if (empty) mutableListOf<Attachment>() else column.value.map { it.toMap() }.toMutableList()
                is FileColumn -> if (empty) mutableListOf<Attachment>() else column.value.map { it.toMap() }.toMutableList()
                is MultiSelectColumn -> if (empty) mutableListOf<String>() else column.value.toMutableList()
                else -> null
            }
        )
    }.toMap().toMutableMap()
)