package joyfill.editors.table.internal

import joyfill.Type
import joyfill.editors.table.ColumnFilter
import joyfill.editors.table.ColumnSorter
import joyfill.editors.table.TableFilterState
import joyfill.table.Column

internal data class TableFilterStateImpl(
    override val isActive: Boolean,
    override val columns: List<Column>,
    override val filterColumns: List<Column>,
    override val sortColumns: List<Column>,
    override val sorter: ColumnSorter?,
    override val filters: List<ColumnFilter>,
) : TableFilterState {
    companion object {
        fun empty(columns: List<Column>): TableFilterStateImpl {
            val allColumns = columns.filter {
                it.type == Type.text || it.type == Type.number || it.type == Type.barcode || it.type == Type.dropdown || it.type == Type.multiSelect
            }
            val sortColumns = allColumns.filterNot { it.type == Type.multiSelect }
            return TableFilterStateImpl(
                isActive = false,
                columns = allColumns,
                filterColumns = allColumns,
                sortColumns = sortColumns,
                sorter = null,
                filters = emptyList(),
            )
        }
    }
}