package joyfill.editors.table


data class RowState<out M : RowManager>(
    val selected: List<M>,
    val filtered: List<M>?,
    val all: List<M>,
) {
    fun selection(): Selection = when {
        all.isEmpty() -> Selection.None
        selected.size == all.size -> Selection.All
        selected.isEmpty() -> Selection.None
        selected.isNotEmpty() -> Selection.Some(selected)
        else -> Selection.None
    }

    fun displaying() = when (filtered) {
        null -> all
        else -> filtered
    }
}