package joyfill.editors.table

import cinematic.Live
import joyfill.table.Row


interface Rows<out M : RowManager> {
    val state: Live<RowState<M>>
    fun all(): List<M>
    fun append(defaultId: String? = null, origin: Origin = Origin.User): M
    fun appendAfter(id: String, defaultId: String? = null, origin: Origin = Origin.User): M?
    fun create(empty: Boolean = false, id: String? = null): M
    fun find(id: String): M?
    fun delete(keys: List<String>, origin: Origin = Origin.User): List<M>
    fun up(id: String, by: Int = 1, origin: Origin = Origin.User): RowResult<Row>
    fun down(id: String, by: Int = 1, origin: Origin = Origin.User): RowResult<Row>
    fun applyFilters(editor: TableEditor): List<M>

    fun disableFilters()
}