package joyfill.editors.table

import cinematic.Live
import joyfill.editors.components.ComponentEditorFinder
import joyfill.table.Row

interface RowManager : ComponentEditorFinder {
    val id: String
    val row: Row

    val state: Live<RowManagerState>
    fun select(): RowManager
    fun unselect(): RowManager
    val next: () -> RowManager?
    val prev: () -> RowManager?
    fun copyInto(other: RowManager)

    /**
     * Gets the validation state of all cells.
     * If the state is unset, it will validate the cells first.
     * @return true if all cells are valid, false otherwise
     */
    fun validateRow(): Boolean

    fun setHidden(value: Boolean, reason: HiddenReason, liveUpdate: Boolean = false)
}
