package joyfill.editors.table

import joyfill.barcode.BarcodeColumn
import joyfill.block.BlockColumn
import joyfill.date.DateColumn
import joyfill.dropdown.DropdownColumn
import joyfill.file.FileColumn
import joyfill.image.ImageColumn
import joyfill.multi_select.MultiSelectColumn
import joyfill.number.NumberColumn
import joyfill.signature.SignatureColumn
import joyfill.table.Column
import joyfill.table.Finder
import joyfill.text.TextColumn
import joyfill.text_area.TextAreaColumn

interface ColumnFinder : Finder<Column> {
    override fun text(key: String?): TextColumn?
    override fun block(key: String?): BlockColumn?
    override fun textArea(key: String?): TextAreaColumn?
    override fun barcode(key: String?): BarcodeColumn?
    override fun number(key: String?): NumberColumn?
    override fun date(key: String?): DateColumn?
    override fun dropdown(key: String?): DropdownColumn?
    override fun multiSelect(key: String?): MultiSelectColumn?
    override fun image(key: String?): ImageColumn?
    override fun file(key: String?): FileColumn?
    override fun signature(key: String?): SignatureColumn?
}


