package joyfill.editors.signature

import joyfill.Document
import joyfill.collections.PageCollection
import joyfill.editors.components.ComponentEditor
import joyfill.editors.components.internal.AbstractCompStringEditorImpl
import joyfill.events.ChangeEvent
import joyfill.events.EventDispatcher
import joyfill.signature.SignatureComponent
import joyfill.tools.validation.ComponentValidity
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class SignatureEditorImpl(
    component: SignatureComponent,
    dependents: () -> List<ComponentEditor>,
    resolver: ResolutionResource,
    library: Library?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractCompStringEditorImpl<SignatureComponent>(
    component = component,
    dependents = dependents,
    resolver = resolver,
    library = library,
    document = document,
    pages = pages,
    onChange = onChange,
    onValidate = onValidate,
    fieldId = fieldId,
    identifier = identifier,
    dispatcher = dispatcher,
), SignatureEditor