package joyfill.editors.number

import cinematic.Live
import joyfill.editors.components.ComponentEditor
import joyfill.editors.table.Origin

interface NumberEditor : ComponentEditor {
    override val state: Live<NumberEditorState>
    // Notify change only if the row is created by user action
    // This prevents unnecessary notifications for programmatic row creations
    fun value(v: Double?, origin: Origin = Origin.User)
    fun value(v: Number?) = value(v?.toDouble())
}