package joyfill.editors.dropdown

import cinematic.Live
import joyfill.editors.components.ComponentEditor
import joyfill.editors.table.Origin
import joyfill.editors.utils.OptionSelector
import joyfill.utils.Option

interface DropdownEditor : ComponentEditor, OptionSelector {
    val options: List<Option>
    override val state: Live<DropdownEditorState>

    /**
     * Sets the dropdown value based on a calculated formula result
     */
    fun value(v: String?, origin: Origin = Origin.User)
    override val isMulti: Boolean get() = false
}