package joyfill.editors.document.helper

import joyfill.editors.components.AbstractCompStringEditor
import joyfill.editors.components.ComponentEditor
import joyfill.editors.date.DateEditor
import joyfill.editors.dropdown.DropdownEditor
import joyfill.editors.file.AbstractFileEditor
import joyfill.editors.multi_select.MultiSelectEditor
import joyfill.editors.number.NumberEditor
import joyfill.editors.table.Origin

internal fun ComponentEditor.update(newValue: Any?) {
    when (this) {
        is NumberEditor -> value(newValue as? Double, origin = Origin.Sdk)
        is DateEditor -> value(newValue as? Long, origin = Origin.Sdk)
        is AbstractCompStringEditor -> value(newValue as? String, origin = Origin.Sdk)
        is DropdownEditor -> value(newValue as? String, origin = Origin.Sdk)
        is AbstractFileEditor -> value(newValue.asAttachments().orEmpty(), origin = Origin.Sdk)
        is MultiSelectEditor -> value(newValue.asOptions().orEmpty(), origin = Origin.Sdk)
    }
} 