package joyfill.editors.document

data class LayoutConfig(
    internal val preferred: Viewer,
    internal val forced: Boolean
) {
    companion object {
        /**
         * Forces the editor to use the mobile layout. If it is not explicitly defined in the document, then we will have no fields to work with
         */
        fun forcedMobile() = LayoutConfig(preferred = Viewer.Mobile, forced = true)

        /**
         * That Editor will do it's best to work with a convenient mobile layout.
         *
         * If there is no mobile layout that is explicitly defined,
         * A convenient mobile layout will be constructed but still
         * won't explicitly define the mobile layout in the document
         */
        fun convenientMobile() = LayoutConfig(preferred = Viewer.Mobile, forced = false)
    }
}