package joyfill.editors.document

import cinematic.Live
import joyfill.Document
import joyfill.Error
import joyfill.Mappable
import joyfill.Stage
import joyfill.View
import joyfill.collections.FieldCollection
import joyfill.collections.PageCollection
import joyfill.editors.event.EventCapture
import joyfill.tools.validation.FieldsValidity

interface DocumentEditor : Mappable {
    var stage: Stage

    var name: String

    var id: String

    var identifier: String

    val fields: FieldCollection

    val views: List<View>

    val pages: PageCollection

    val capturedEvents: MutableList<EventCapture>

    val error: Live<Error?>

    fun set(key: String, value: Any?)

    fun <R> get(key: String): R

    fun integrity(): FieldsValidity

    fun resolveConditions()

    fun toDocument(): Document

    fun validate(): FieldsValidity
}