package joyfill.editors.date

import cinematic.Live
import joyfill.editors.components.ComponentEditor
import joyfill.editors.table.Origin
import kotlinx.datetime.TimeZone

interface DateEditor : ComponentEditor {

    override val state: Live<DateEditorState>

    val format: String?

    val timeZone: TimeZone

    // Notify change only if the row is created by user action
    // This prevents unnecessary notifications for programmatic row creations
    fun value(millis: Long?, origin: Origin = Origin.User)
}