package joyfill.editors.components.internal

import joyfill.Document
import joyfill.Field
import joyfill.IdentityGenerator
import joyfill.barcode.BarcodeField
import joyfill.block.BlockField
import joyfill.chart.ChartField
import joyfill.collection.CollectionField
import joyfill.collections.PageCollection
import joyfill.date.DateField
import joyfill.dropdown.DropdownField
import joyfill.editors.barcode.BarcodeEditorImpl
import joyfill.editors.block.BlockEditorImpl
import joyfill.editors.chart.internal.ChartEditorImpl
import joyfill.editors.collection.internal.CollectionEditorImpl
import joyfill.editors.components.ComponentEditor
import joyfill.editors.date.internal.DateEditorImpl
import joyfill.editors.dropdown.internal.DropdownEditorImpl
import joyfill.editors.file.internal.FileEditorImpl
import joyfill.editors.image.ImageEditorImpl
import joyfill.editors.multi_select.internal.MultiSelectEditorImpl
import joyfill.editors.number.internal.NumberEditorImpl
import joyfill.editors.signature.SignatureEditorImpl
import joyfill.editors.table.internal.TableEditorImpl
import joyfill.editors.text.TextEditorImpl
import joyfill.editors.text_area.TextAreaEditorImpl
import joyfill.editors.unknown.UnknownEditor
import joyfill.events.ChangeEvent
import joyfill.events.EventDispatcher
import joyfill.file.FileField
import joyfill.image.ImageField
import joyfill.multi_select.MultiSelectField
import joyfill.number.NumberField
import joyfill.signature.SignatureField
import joyfill.table.TableField
import joyfill.text.TextField
import joyfill.text_area.TextAreaField
import wisdom.ResolutionResource
import wisdom.ast.Library

internal fun Field.toEditor(
    cache: MutableMap<String, ComponentEditor>,
    document: Document,
    pages: PageCollection,
    identity: IdentityGenerator,
    resolver: ResolutionResource,
    library: Library?,
    onChange: ((ChangeEvent) -> Unit)?,
    dispatcher: EventDispatcher,
    dependents: () -> List<ComponentEditor>,
    circularFields: Set<String> = emptySet()
): ComponentEditor = cache.getOrPut(id) {
    val effectiveLibrary = if (id in circularFields) null else library

    when (this) {
        is TextField -> TextEditorImpl(
            component = this,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            document = document,
            onChange = onChange,
            onValidate = {},
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is BlockField -> BlockEditorImpl(
            component = this,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is TextAreaField -> TextAreaEditorImpl(
            component = this,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            document = document,
            onChange = onChange,
            onValidate = {},
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is TableField -> TableEditorImpl(
            component = this,
            identity = identity,
            document = document,
            pages = pages,
            onChange = onChange,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            dispatcher = dispatcher,
        )

        is BarcodeField -> BarcodeEditorImpl(
            component = this,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            document = document,
            onChange = onChange,
            onValidate = {},
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is CollectionField -> CollectionEditorImpl(
            component = this,
            identity = identity,
            document = document,
            pages = pages,
            onChange = onChange,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            dispatcher = dispatcher,
        )

        is ChartField -> ChartEditorImpl(
            component = this,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            document = document,
            identity = identity,
            pages = pages,
            onChange = onChange,
            dispatcher = dispatcher,
        )

        is NumberField -> NumberEditorImpl(
            component = this,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            pages = pages,
            document = document,
            onChange = onChange,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is DateField -> DateEditorImpl(
            component = this,
            format = null,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher,
            library = effectiveLibrary,
            resolver = resolver,
            dependents = dependents
        )

        is DropdownField -> DropdownEditorImpl(
            component = this,
            options = this.options,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is SignatureField -> SignatureEditorImpl(
            component = this,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is ImageField -> ImageEditorImpl(
            component = this,
            identity = identity,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary
        )

        is FileField -> FileEditorImpl(
            component = this,
            identity = identity,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary
        )

        is MultiSelectField -> MultiSelectEditorImpl(
            component = this,
            options = options,
            document = document,
            onChange = onChange,
            onValidate = {},
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary
        )

        else -> UnknownEditor(
            component = this,
            document = document,
            onChange = onChange,
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher,
            dependents = dependents,
            resolver = resolver,
            library = effectiveLibrary
        )
    }
}