package joyfill.editors.components.internal

import joyfill.editors.barcode.BarcodeEditor
import joyfill.editors.block.BlockEditor
import joyfill.editors.components.ComponentEditorFinder
import joyfill.editors.date.DateEditor
import joyfill.editors.dropdown.DropdownEditor
import joyfill.editors.file.FileEditor
import joyfill.editors.image.ImageEditor
import joyfill.editors.multi_select.MultiSelectEditor
import joyfill.editors.number.NumberEditor
import joyfill.editors.signature.SignatureEditor
import joyfill.editors.text.TextEditor
import joyfill.editors.text_area.TextAreaEditor

abstract class AbstractComponentEditorFinder : ComponentEditorFinder {
    override fun text(key: String?): TextEditor? = find(key) as? TextEditor
    override fun signature(key: String?): SignatureEditor? = find(key) as? SignatureEditor
    override fun block(key: String?): BlockEditor? = find(key) as? BlockEditor
    override fun textArea(key: String?): TextAreaEditor? = find(key) as? TextAreaEditor
    override fun number(key: String?): NumberEditor? = find(key) as? NumberEditor
    override fun dropdown(key: String?): DropdownEditor? = find(key) as? DropdownEditor
    override fun image(key: String?): ImageEditor? = find(key) as? ImageEditor
    override fun file(key: String?): FileEditor? = find(key) as? FileEditor
    override fun multiSelect(key: String?): MultiSelectEditor? = find(key) as? MultiSelectEditor
    override fun barcode(key: String?): BarcodeEditor? = find(key) as? BarcodeEditor
    override fun date(key: String?): DateEditor? = find(key) as? DateEditor
}