package joyfill.editors.components

import joyfill.components.Component
import joyfill.editors.table.HiddenReason
import joyfill.schemas.Schema
import joyfill.tools.validation.ValidateEditor
import joyfill.tooltip.ToolTip

interface ComponentEditor : ValidateEditor, Schema {
    val component: Component

    var identifier: String
    val disabled: Boolean
    val tip: ToolTip?

    fun resolveConditions()
    fun updateDependentsValues()
    fun hide()
    fun show()
    fun setHiddenTo(value: Boolean, reason: HiddenReason, liveUpdate: Boolean = false)
}