package joyfill.editors.collection.internal

import cinematic.MutableLive
import cinematic.mutableLiveOf
import joyfill.IdentityGenerator
import joyfill.collection.TableSchemas
import joyfill.editors.collection.CollectionEditor
import joyfill.editors.collection.FilterCollection
import joyfill.editors.collection.TableEditor
import joyfill.editors.collection.TableFilter
import joyfill.table.TableSchema

internal class FilterCollectionImpl(
    schemas: TableSchemas,
    private val host: CollectionEditor,
    private val identity: IdentityGenerator,
    private val beforeFiltering: (id: String) -> Unit,
    private val disableFilter: () -> Unit,
    private val afterFiltering: (id: String, editors: List<TableEditor>, hasSorter: Boolean) -> Unit,
) : FilterCollection, TableSchemas by schemas {

    override val schemas by lazy { this }

    override val current: MutableLive<TableFilter?> by lazy { mutableLiveOf(null) }

    override val isActive: Boolean
        get() = current.value?.state?.value?.isActive == true

    override fun select(schema: TableSchema): TableFilter {
        var editors: List<TableEditor> = emptyList()
        val filter = TableFilterImpl(
            root = host.root(),
            schema = schema,
            identity = identity,
            disableFilter = disableFilter,
            host = host,
            getEditors = {
                editors = schema.editors
                editors
            },
            beforeFiltering = { beforeFiltering(schema.id) },
            afterFiltering = {
                afterFiltering(
                    schema.id,
                    editors,
                    (current.value?.state?.value?.sorter != null)
                )
            },
        )
        disable()
        current.value = filter
        return filter
    }

    override fun select(editor: TableEditor): TableFilter = select(editor.component)

    // Adds an empty filter to the current selected TableSchema
    override fun addFilter(): TableFilter? {
        current.value?.addFilter()
        return current.value
    }

    // Adds an empty sorter to the current selected TableSchema
    override fun addSorter(): TableFilter? {
        current.value?.addSorter()
        return current.value
    }

    // removes a specific filter by id
    override fun removeFilter(id: String) {
        current.value?.removeFilter(id)
    }

    // removes the sorter if there is any
    override fun removeSorter() {
        current.value?.removeSorter()
    }

    // Applies the filters + sorter if there is any
    override fun apply() {
        current.value?.apply()
    }

    override fun disable() {
        current.value?.disable()
        current.value = null
    }

    override fun enable() {
        current.value?.enable()
    }

    private val TableSchema.editors: List<TableEditor>
        get() = if (host is CollectionEditorImpl) {
            host.tableEditors.filter {
                it.component.identifier == id &&
                        it.state.value.visibility.isFilteredOrVisible()
            }
        } else {
            emptyList()
        }
}