package joyfill.editors.collection.entries

import joyfill.editors.collection.RowManager
import joyfill.editors.collection.TableEditor

data class RowEntry(
    override val level: Int,
    override val table: TableEditor,
    override val expanded: Boolean,
    override val hidden: Boolean,
    val number: Int,
    val manager: RowManager,
    override val isValid: Boolean,
) : LazyEntry {
    override val id: String = manager.id
    override val name: String = "RowEntry"
    override fun copy(expanded: Boolean) = RowEntry(level, table, expanded, hidden, number, manager, isValid)
}