package joyfill.editors.collection

import cinematic.Live
import joyfill.collection.CollectionComponent
import joyfill.editors.collection.entries.LazyEntry
import joyfill.editors.collection.entries.RowEntry
import joyfill.editors.collection.entries.TableEntry
import joyfill.editors.components.ComponentEditor
import joyfill.editors.table.RowFormEditor
import joyfill.editors.table.Selection
import joyfill.editors.utils.Selector

interface CollectionEditor : ComponentEditor, RowFormEditor, Selector<RowEntry> {
    override val component: CollectionComponent
    override val state: Live<CollectionEditorState>
    override val isMulti: Boolean
    val filters: FilterCollection
    fun root(): TableEditor
    fun toggle(entry: LazyEntry)
    fun expandRow(entry: RowEntry)
    fun selectAll(entry: TableEntry)
    fun selection(entry: TableEntry): Selection
    fun addAfter()
    fun moveUp()
    fun moveDown()
    fun addFormAfter()
    fun delete()
}