package joyfill.editors.chart.internal

import joyfill.chart.Point
import joyfill.editors.chart.PointEditor

@PublishedApi
internal class PointEditorImpl(
    override val point: Point,
    private val onValueChange: (() -> Unit)? = null
) : PointEditor {
    override fun label(value: String) {
        point.label = value
        onValueChange?.invoke()
    }

    override fun label() = point.label.orEmpty()

    override fun x(value: Double) {
        point.x = value
        onValueChange?.invoke()
    }

    override fun x() = point.x

    override fun y(value: Double) {
        point.y = value
        onValueChange?.invoke()
    }

    override fun y() = point.y
}