package joyfill.editors.barcode

import joyfill.Document
import joyfill.barcode.BarcodeComponent
import joyfill.collections.PageCollection
import joyfill.editors.components.ComponentEditor
import joyfill.editors.components.internal.AbstractCompStringEditorImpl
import joyfill.events.ChangeEvent
import joyfill.events.EventDispatcher
import joyfill.tools.validation.ComponentValidity
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class BarcodeEditorImpl(
    component: BarcodeComponent,
    dependents: () -> List<ComponentEditor>,
    resolver: ResolutionResource,
    library: Library?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractCompStringEditorImpl<BarcodeComponent>(
    component = component,
    document = document,
    pages = pages,
    dependents = dependents,
    resolver = resolver,
    library = library,
    onChange = onChange,
    onValidate = onValidate,
    fieldId = fieldId,
    identifier = identifier,
    dispatcher = dispatcher
), BarcodeEditor