package joyfill.tools.validation

import joyfill.Mappable
import joyfill.utils.toJsonObject
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject

sealed interface FieldsValidity : Validity, Mappable {
    val fields: List<ComponentValidity>

    override fun toJsonObject(): JsonObject =  toMap().toJsonObject()
    override fun toJsonString(): String =  Json.encodeToString(toJsonObject())
}

data class FieldsValid(
    override val fields: List<ComponentValidity>
) : FieldsValidity, Valid {
    init {
        require(fields.all { it is Valid }) { "All fields must be valid" }
    }
    override fun toMap(): MutableMap<String, Any?> {
        val fieldValidations = fields.map {
            mutableMapOf(
                "field" to it.component.toMap(),
                "status" to "valid"
            )
        }
        return mutableMapOf(
            "fieldValidations" to fieldValidations
        )
    }
}


data class FieldsInvalid(
    override val fields: List<ComponentValidity>
) : FieldsValidity, Invalid {
    override fun toMap(): MutableMap<String, Any?> {
        val fieldValidations = fields.map {
            mutableMapOf(
                "field" to it.component.toMap(),
                "status" to if (it is Invalid) "invalid" else "valid"
            )
        }
        return mutableMapOf(
            "fieldValidations" to fieldValidations
        )
    }
}
