package joyfill.tools.validation

import joyfill.Field

sealed interface FieldValidity : Validity {
    val field: Field
    val messages: List<String>
}

data class FieldValid(
    override val field: Field,
    override val messages: List<String>
) : FieldValidity, Valid

data class FieldInvalid(
    override val field: Field,
    override val messages: List<String>
) : FieldValidity, Invalid