package joyfill.events.internal

import joyfill.events.RowUpdateChange
import joyfill.table.Column
import joyfill.table.Row
import joyfill.table.toTableRow


internal class RowUpdateChangeImpl(
    columns: List<Column>,
    private val wrapped: Map<String, Any?>
) : RowUpdateChange, RowChangeImpl(wrapped) {

    override val rowId: String by lazy { wrapped[RowUpdateChange::rowId.name].toString() }

    override val columnId: String by lazy { wrapped[RowUpdateChange::columnId.name].toString() }

    override val row: Row by lazy {
        (wrapped[RowUpdateChange::row.name] as Map<String, Any?>).toMutableMap().toTableRow(columns)
    }
}