package joyfill.events.internal

import joyfill.events.RowCreateChange
import joyfill.table.Column
import joyfill.table.Row
import joyfill.table.toTableRow

internal class RowCreateChangeImpl(
    columns: List<Column>,
    private val wrapped: Map<String, Any?>
) : RowCreateChange, RowChangeImpl(wrapped) {

    override val targetRowIndex: Int by lazy {
        wrapped[RowCreateChange::targetRowIndex.name] as Int
    }

    override val row: Row by lazy {
        (wrapped[RowCreateChange::row.name] as Map<String, Any?>).toMutableMap().toTableRow(columns)
    }
}