package joyfill.events.internal

import joyfill.events.Change
import joyfill.events.ChangeLog
import joyfill.events.Target
import joyfill.events.toFieldChange
import joyfill.events.toRowCreateChange
import joyfill.events.toRowDeleteChange
import joyfill.events.toRowMoveChange
import joyfill.events.toRowUpdateChange
import joyfill.events.toUnknownChange
import joyfill.internal.AbstractMappable
import joyfill.table.Column
import joyfill.table.TableSchema
import joyfill.utils.ID

internal class ChangeLogImpl(
    private val columns: List<Column>,
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped),
    ChangeLog {
    override val id: String get() = wrapped[ID] as String
    override val identifier: String get() = wrapped[ChangeLog::identifier.name] as String
    override val fieldId: String get() = wrapped[ChangeLog::fieldId.name] as String
    override val fieldIdentifier: String get() = wrapped[ChangeLog::fieldIdentifier.name] as String
    override val pageId: String get() = wrapped[ChangeLog::pageId.name] as String
    override val fileId: String get() = wrapped[ChangeLog::fileId.name] as String
    override val fieldPositionId: String get() = wrapped[ChangeLog::fieldPositionId.name] as String
    override val target: String get() = wrapped[ChangeLog::target.name] as String
    override val createdOn: Long get() = wrapped[ChangeLog::createdOn.name] as Long
    override val change: Change
        get() {
            val type = target
            val change = (wrapped[ChangeLog::change.name] as MutableMap<String, Any?>)
            return when (type) {
                Target.field_update -> change.toFieldChange()
                Target.field_value_rowCreate -> change.toRowCreateChange(columns)
                Target.field_value_rowDelete -> change.toRowDeleteChange()
                Target.field_value_rowUpdate -> change.toRowUpdateChange(columns)
                Target.field_value_rowMove -> change.toRowMoveChange()
                else -> change.toUnknownChange()
            }
        }
    override val sdk: String get() = wrapped[ChangeLog::sdk.name] as String
    override val v: Int get() = wrapped[ChangeLog::v.name] as Int

    override fun toMap(): MutableMap<String, Any?> = wrapped.apply {
        remove(TableSchema::columns.name)
    }
}