package joyfill.events.internal


import joyfill.Document
import joyfill.events.ChangeEvent
import joyfill.events.ChangeLog
import joyfill.events.toChangeLog
import joyfill.internal.AbstractMappable
import joyfill.table.Column
import joyfill.toDocument
import joyfill.utils.JsonList
import joyfill.utils.toJsonObject
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject

internal class ChangeEventImpl(
    private val columns: List<Column>,
    wrapped: MutableMap<String, Any?>,
) : AbstractMappable(wrapped), ChangeEvent {

    override val changelogs: List<ChangeLog> by lazy {
        JsonList(
            parent = wrapped,
            key = ChangeEvent::changelogs.name,
            factory = { it.toChangeLog(columns) },
        )
    }

    override val document: Document by lazy {
        (wrapped[ChangeEvent::document.name] as MutableMap<String, Any?>).toDocument()
    }

    override fun toMap() = wrapped

    override fun toJsonString(): String = Json.encodeToString(toJsonObject())

    override fun toJsonObject(): JsonObject = wrapped.toJsonObject()
}