package joyfill.events

import joyfill.events.internal.ChangeEventImpl
import joyfill.events.internal.ChangeLogImpl
import joyfill.events.internal.FieldUpdateChangeImpl
import joyfill.events.internal.RowCreateChangeImpl
import joyfill.events.internal.RowDeleteChangeImpl
import joyfill.events.internal.RowMoveChangeImpl
import joyfill.events.internal.RowUpdateChangeImpl
import joyfill.events.internal.UnknownChangeImpl
import joyfill.table.Column

fun MutableMap<String, Any?>.toChangeLog(columns: List<Column>): ChangeLog = ChangeLogImpl(columns, this)

fun MutableMap<String, Any?>.toChangeEvent(columns: List<Column>): ChangeEvent = ChangeEventImpl(columns, this)

fun MutableMap<String, Any?>.toFieldChange(): FieldUpdateChange = FieldUpdateChangeImpl(this)

fun MutableMap<String, Any?>.toRowCreateChange(columns: List<Column>): RowCreateChange = RowCreateChangeImpl(columns,this)

fun MutableMap<String, Any?>.toRowMoveChange(): RowMoveChange = RowMoveChangeImpl(this)

fun MutableMap<String, Any?>.toRowDeleteChange(): RowDeleteChange = RowDeleteChangeImpl(this)

fun MutableMap<String, Any?>.toRowUpdateChange(columns: List<Column>): RowUpdateChange = RowUpdateChangeImpl(columns,this)

fun MutableMap<String, Any?>.toUnknownChange(): Change = UnknownChangeImpl(this)