package joyfill.editors.utils

import kotlinx.datetime.IllegalTimeZoneException
import kotlinx.datetime.TimeZone

fun timezoneFromId(id: String?): TimeZone? = if (id.isNullOrEmpty()) null else {
    try {
        TimeZone.of(id)
    } catch (_: IllegalTimeZoneException) {
        null
    }
}

val localTimeZone: TimeZone = TimeZone.currentSystemDefault()

