package joyfill.editors.utils

sealed interface Submission {
    data object Pending : Submission
    data class Submitting(
        val completed: Int = 0,
        val total: Int = 0,
    ) : Submission {
        val remaining by lazy { total - completed }
    }
    data class Submitted(val total: Int) : Submission
}