package joyfill.editors.text_area

import joyfill.Document
import joyfill.collections.PageCollection
import joyfill.editors.components.ComponentEditor
import joyfill.editors.components.internal.AbstractCompStringEditorImpl
import joyfill.events.ChangeEvent
import joyfill.events.EventDispatcher
import joyfill.text_area.TextAreaComponent
import joyfill.tools.validation.ComponentValidity
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class TextAreaEditorImpl(
    component: TextAreaComponent,
    dependents: () -> List<ComponentEditor>,
    resolver: ResolutionResource,
    library: Library?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractCompStringEditorImpl<TextAreaComponent>(
    component = component,
    document = document,
    pages = pages,
    dependents = dependents,
    resolver = resolver,
    library = library,
    onChange = onChange,
    onValidate = onValidate,
    fieldId = fieldId,
    identifier = identifier,
    dispatcher = dispatcher,
), TextAreaEditor