package joyfill.editors.text

import joyfill.Document
import joyfill.collections.PageCollection
import joyfill.editors.components.ComponentEditor
import joyfill.editors.components.internal.AbstractCompStringEditorImpl
import joyfill.events.ChangeEvent
import joyfill.events.EventDispatcher
import joyfill.text.TextComponent
import joyfill.tools.validation.ComponentValidity
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class TextEditorImpl(
    component: TextComponent,
    dependents: () -> List<ComponentEditor>,
    resolver: ResolutionResource,
    library: Library?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractCompStringEditorImpl<TextComponent>(
    component = component,
    document = document,
    pages = pages,
    dependents = dependents,
    resolver = resolver,
    library = library,
    onChange = onChange,
    onValidate = onValidate,
    identifier = identifier,
    fieldId = fieldId,
    dispatcher = dispatcher,
), TextEditor