package joyfill.editors.table.internal

import joyfill.editors.table.RowManager
import joyfill.editors.table.RowVisibility
import joyfill.editors.table.Selection
import joyfill.editors.table.TableEditorState
import joyfill.tools.validation.ComponentValidity

data class TableEditorStateImpl(
    override val validity: ComponentValidity,
    override val rows: List<RowManager>,
    override val selected: List<RowManager>,
    override val form: RowManager?,
    override val visibility: RowVisibility,
) : TableEditorState {

    fun selection(): Selection = when {
        selected.isEmpty() -> Selection.None
        selected.size == rows.size -> Selection.All
        selected.isEmpty() -> Selection.None
        selected.isNotEmpty() -> Selection.Some(selected)
        else -> Selection.None
    }
}