package joyfill.editors.table.internal

import joyfill.Document
import joyfill.IdentityGenerator
import joyfill.editors.components.ComponentEditor
import joyfill.editors.table.RowManager
import joyfill.events.ChangeEvent
import joyfill.events.EventDispatcher
import joyfill.table.Column
import joyfill.table.Row
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class RowManagerImpl(
    override val row: Row,
    columns: List<Column>,
    required: Boolean,
    document: Document,
    identity: IdentityGenerator,
    onChange: ((columnId: String, ChangeEvent) -> Unit)?,
    override val next: () -> RowManager?,
    override val prev: () -> RowManager?,
    fieldId: String,
    identifier: String,
    dependents: () -> List<ComponentEditor>,
    resolver: ResolutionResource,
    library: Library?,
    dispatcher: EventDispatcher?,
) : AbstractRowManager(
    row = row,
    document = document,
    columns = columns,
    required = required,
    identity = identity,
    onChange = onChange,
    fieldId = fieldId,
    identifier = identifier,
    dependents = dependents,
    resolver = resolver,
    library = library,
    dispatcher = dispatcher
) {
    override val id: String = row.id
}