package joyfill.editors.table.internal

import joyfill.barcode.BarcodeColumn
import joyfill.block.BlockColumn
import joyfill.date.DateColumn
import joyfill.dropdown.DropdownColumn
import joyfill.editors.table.ColumnFinder
import joyfill.file.FileColumn
import joyfill.image.ImageColumn
import joyfill.multi_select.MultiSelectColumn
import joyfill.number.NumberColumn
import joyfill.signature.SignatureColumn
import joyfill.table.Column
import joyfill.text.TextColumn
import joyfill.text_area.TextAreaColumn

internal abstract class AbstractColumnFinder(
    private val columns: List<Column>,
) : ColumnFinder {

    override fun all(): List<Column> = columns

    private fun look(key: String): Column? = columns.find { key == it.id || key.equals(it.title, ignoreCase = true) }

    override fun find(key: String?): Column? = key?.let { look(key) }

    override fun text(key: String?): TextColumn? = find(key) as? TextColumn

    override fun signature(key: String?): SignatureColumn? = find(key) as? SignatureColumn

    override fun block(key: String?): BlockColumn? = find(key) as? BlockColumn

    override fun barcode(key: String?): BarcodeColumn? = find(key) as? BarcodeColumn

    override fun textArea(key: String?): TextAreaColumn? = find(key) as? TextAreaColumn

    override fun multiSelect(key: String?): MultiSelectColumn? = find(key) as? MultiSelectColumn

    override fun number(key: String?): NumberColumn? = find(key) as? NumberColumn

    override fun date(key: String?): DateColumn? = find(key) as? DateColumn

    override fun dropdown(key: String?): DropdownColumn? = find(key) as? DropdownColumn

    override fun image(key: String?): ImageColumn? = find(key) as? ImageColumn

    override fun file(key: String?): FileColumn? = find(key) as? FileColumn
}