package joyfill.editors.table

import kotlinx.JsName

sealed interface RowVisibility {
    data object Visible : RowVisibility
    data class Hidden(val reason: HiddenReason) : RowVisibility

    fun isHidden(): Boolean {
        return this is Hidden
    }

    fun isVisible(): Boolean {
        return this is Visible
    }

    @JsName("hiddenReason")
    fun reason(): HiddenReason? {
        return if (this is Hidden) reason else null
    }

    fun isFiltered(): Boolean {
        return this is Hidden && reason != HiddenReason.CONDITIONAL_LOGIC
    }

    fun isFilteredOrVisible(): Boolean {
        return when (this) {
            is Hidden -> reason != HiddenReason.CONDITIONAL_LOGIC
            is Visible -> true
        }
    }
}