package joyfill.editors.table

import joyfill.IdentityGenerator
import joyfill.Type
import joyfill.barcode.BarcodeColumn
import joyfill.dropdown.DropdownColumn
import joyfill.editors.table.internal.ColumnSorterImpl
import joyfill.number.NumberColumn
import joyfill.table.Column
import joyfill.text.TextColumn

interface ColumnSorter: ColumnTransformer {
    var sort: SortingOption
    val type: Type?

    companion object {
        fun from(
            column: Column?,
            identityGenerator: IdentityGenerator,
            sort: SortingOption = SortingOption.None,
        ): ColumnSorter {
            val id = identityGenerator.generate()
            return when (column) {
                null -> ColumnSorterImpl(null, null, id)
                is TextColumn -> ColumnSorterImpl(column, Type.text, id, sort)
                is NumberColumn -> ColumnSorterImpl(column, Type.number, id, sort)
                is DropdownColumn -> ColumnSorterImpl(column, Type.dropdown, id, sort)
                is BarcodeColumn -> ColumnSorterImpl(column, Type.barcode, id, sort)
                else -> throw IllegalArgumentException("Unsupported column (type = ${column.type.name}) for sorting")
            }
        }
    }
}