package joyfill.editors.table

import joyfill.IdentityGenerator
import joyfill.barcode.BarcodeColumn
import joyfill.dropdown.DropdownColumn
import joyfill.multi_select.MultiSelectColumn
import joyfill.number.NumberColumn
import joyfill.table.Column
import joyfill.text.TextColumn
import joyfill.utils.Option

sealed interface ColumnFilter: ColumnTransformer {
    val value: Any?

    companion object {
        fun from(column: Column?, value: Any? = null, identity: IdentityGenerator): ColumnFilter {
            val id = identity.generate()
            return when (column) {
                null -> EmptyColumnFilter(id = id)
                is TextColumn -> TextColumnFilter(column, value as? String, id)
                is NumberColumn -> NumberColumnFilter(column, value as? String, id)
                is DropdownColumn -> DropdownColumnFilter(column, value as? Option, id)
                is MultiSelectColumn -> MultiselectColumnFilter(column, value as? Option, id)
                is BarcodeColumn -> BarcodeColumnFilter(column, value as? String, id)
                else -> throw IllegalArgumentException("Unsupported column (type = ${column.type.name}) for filtering")
            }
        }
    }

    data class EmptyColumnFilter(
        override val column: Column? = null,
        override val value: String? = null,
        override val id: String,
    ) : ColumnFilter

    data class  TextColumnFilter(
        override val column: TextColumn,
        override val value: String?,
        override val id: String,
    ) : ColumnFilter

    data class NumberColumnFilter(
        override val column: NumberColumn,
        override val value: String?,
        override val id: String,
    ) : ColumnFilter

    data class BarcodeColumnFilter(
        override val column: BarcodeColumn,
        override val value: String?,
        override val id: String,
    ) : ColumnFilter

    data class DropdownColumnFilter(
        override val column: DropdownColumn,
        override val value: Option?,
        override val id: String,
    ) : ColumnFilter

    data class MultiselectColumnFilter(
        override val column: MultiSelectColumn,
        override val value: Option?,
        override val id: String,
    ) : ColumnFilter
}