package joyfill.editors.image

import joyfill.Document
import joyfill.IdentityGenerator
import joyfill.collections.PageCollection
import joyfill.editors.components.ComponentEditor
import joyfill.editors.file.internal.AbstractFileEditorImpl
import joyfill.events.ChangeEvent
import joyfill.events.EventDispatcher
import joyfill.image.ImageComponent
import joyfill.tools.validation.ComponentValidity
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class ImageEditorImpl(
    override val component: ImageComponent,
    identity: IdentityGenerator,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
    dependents: () -> List<ComponentEditor>,
    resolver: ResolutionResource,
    library: Library?
) : AbstractFileEditorImpl<ImageComponent>(
    component = component,
    identity = identity,
    document = document,
    pages = pages,
    onChange = onChange,
    onValidate = onValidate,
    fieldId = fieldId,
    identifier = identifier,
    dispatcher = dispatcher,
    dependents = dependents,
    resolver = resolver,
    library = library
), ImageEditor