package joyfill.editors.document.helper

import joyfill.IdentityGenerator
import joyfill.utils.Attachment
import joyfill.utils.Option
import joyfill.utils.toAttachment
import joyfill.utils.toOption

internal fun Any?.asAttachments(): List<Attachment>? = when (this) {
    null -> null
    is List<*> -> {
        val attachments = this.mapNotNull { it.asAttachment() }
        if (attachments.isEmpty() && this.isNotEmpty()) null else attachments
    }

    is String -> this.asAttachment()?.let { listOf(it) }
    is Attachment -> listOf(this)
    else -> null
}

internal fun Any?.asAttachment(): Attachment? = when (this) {
    null -> null
    is String -> Attachment(
        id = IdentityGenerator.default.generate(),
        url = this
    )

    is Attachment -> this
    is Map<*, *> -> {
        @Suppress("UNCHECKED_CAST")
        val map = this as? MutableMap<String, Any?>
        map?.toAttachment()
    }

    else -> null
}

internal fun Any?.asOptions(): List<Option>? = when (this) {
    null -> null
    is List<*> -> {
        val options = this.mapNotNull { it.asOption() }
        if (options.isEmpty() && this.isNotEmpty()) null else options
    }

    is String -> this.asOption()?.let { listOf(it) }
    is Option -> listOf(this)
    else -> null
}

internal fun Any?.asOption(): Option? = when (this) {
    null -> null
    is String -> Option(id = this, value = this)
    is Option -> this
    is Map<*, *> -> {
        @Suppress("UNCHECKED_CAST")
        val map = this as? MutableMap<String, Any?>
        map?.toOption()
    }

    else -> null
} 