package joyfill.editors.components

internal interface ValueEvaluator {
    fun isValueEmpty(value: Any?): Boolean = when (value) {
        null -> true
        is String -> value.isBlank()
        is Number -> false
        is Boolean -> false
        is Array<*> -> value.isEmpty()
        is Map<*, *> -> value.isEmpty()
        is Collection<*> -> value.isEmpty()
        else -> false
    }

    fun isGreaterThan(v1: Any?, v2: Any?): Boolean {
        val n1 = v1 as? Number ?: return false
        val n2 = v2 as? Number ?: return false
        return n1.toDouble() > n2.toDouble()
    }

    fun isLessThan(v1: Any?, v2: Any?): Boolean {
        val n1 = v1 as? Number ?: return false
        val n2 = v2 as? Number ?: return false
        return n1.toDouble() < n2.toDouble()
    }
}